/*
 * Decompiled with CFR 0.152.
 */
package mod.beethoven92.betterendforge.common.world.feature;

import java.util.Random;
import mod.beethoven92.betterendforge.common.block.template.DoublePlantBlock;
import mod.beethoven92.betterendforge.common.util.BlockHelper;
import mod.beethoven92.betterendforge.common.util.ModMathHelper;
import mod.beethoven92.betterendforge.common.world.feature.ScatterFeature;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.state.Property;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.IWorldWriter;

public class DoublePlantFeature
extends ScatterFeature {
    private final Block smallPlant;
    private final Block largePlant;
    private Block plant;

    public DoublePlantFeature(Block smallPlant, Block largePlant, int radius) {
        super(radius);
        this.smallPlant = smallPlant;
        this.largePlant = largePlant;
    }

    @Override
    public boolean canGenerate(ISeedReader world, Random random, BlockPos center, BlockPos blockPos, float radius) {
        float d = ModMathHelper.length(center.func_177958_n() - blockPos.func_177958_n(), center.func_177952_p() - blockPos.func_177952_p()) / radius * 0.6f + random.nextFloat() * 0.4f;
        this.plant = d < 0.5f ? this.largePlant : this.smallPlant;
        return this.plant.func_196260_a(this.plant.func_176223_P(), (IWorldReader)world, blockPos);
    }

    @Override
    public void generate(ISeedReader world, Random random, BlockPos blockPos) {
        if (this.plant instanceof DoublePlantBlock) {
            int rot = random.nextInt(4);
            BlockState state = (BlockState)this.plant.func_176223_P().func_206870_a((Property)DoublePlantBlock.ROTATION, (Comparable)Integer.valueOf(rot));
            BlockHelper.setWithoutUpdate((IWorldWriter)world, blockPos, state);
            BlockHelper.setWithoutUpdate((IWorldWriter)world, blockPos.func_177984_a(), (BlockState)state.func_206870_a((Property)DoublePlantBlock.TOP, (Comparable)Boolean.valueOf(true)));
        } else {
            BlockHelper.setWithoutUpdate((IWorldWriter)world, blockPos, this.plant);
        }
    }
}

